/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __DRV_AFE_H
#define __DRV_AFE_H

/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"

/* Private define- ------------------------------------------------------------*/
#define I2C_Speed_1M() I2C->BAUDCR = 1;


/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
enum AFE_RegAdr
{
	OSR = 0x18,
	ENCFG0 = 0x19,
	SIGCFG1 = 0x1A,
	SIGCFG2 = 0x1B,
	VRCFG = 0x1C,
	ENCFG1 = 0x1D,
	PGASET = 0x1E,
	ADCSET = 0x1F,
	DCSET = 0x20,
	TSNS = 0x21,
	IDAC1CTR = 0x22,
	IDAC2CTR = 0x23,
	SYSCLK = 0x24,
	INSTA = 0x25,
	
	RAWL = 0x00,
	RAWM = 0x01,
	RAWH = 0x02,
	
};



void AFE_init(void);

uint32_t AFE_read(uint8_t addr, uint8_t* pbuf , uint8_t len);
uint32_t AFE_write(uint8_t addr , uint8_t* pdata , uint8_t len);


#endif /* __DRV_AFE_H */
