/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint16_t Channel_0_Value[10];
uint32_t Value_Total = 0;
uint8_t complete_flag = 0;
uint8_t buffer_index = 0;;

/* Private function prototypes -----------------------------------------------*/
void MY_ADC_Init(void);

/* Private functions ---------------------------------------------------------*/

void delay(volatile uint32_t n)
{
  while (n--)
    ;
}

int main(void)
{
  SystemCoreClockUpdate();
  uart1_init(24000000, 115200);
  MY_ADC_Init();

  /* Infinite loop */
  while (1)
  {
    if (complete_flag == 0)
    {
      ADC_SoftwareStartConvCmd(ENABLE);
      delay(10000);
    }

    if (complete_flag == 1)
    {
      printf("CH_00 sample values are:\r\n");
      for (buffer_index = 0; buffer_index < 10; buffer_index++)
      {
        Value_Total += Channel_0_Value[buffer_index];
        printf("%-5d\r\n", Channel_0_Value[buffer_index]);
      }
      printf("Total channels value is :%5d\r\n", Value_Total);

      if (Value_Total > 0xFFFFF)
      {
        printf("Total channels value overflow\r\n");
      }
      else
      {
        if (Value_Total != ADC_GetAccValue())
          printf("ADC accumulaition test error\r\n");
        else
          printf("ADC accumulaition test susscess\r\n");
      }

      complete_flag = 2;
    }
  }
}

/**
  * @brief  ADC Configuration(Channel0, single mode, auto acceleration, 
  *         64 clock division, software start, sample time: 8 cycles)
  * @retval None
  */
void MY_ADC_Init(void)
{
  ADC_InitTypeDef ADC_InitStruct;

  RCC_APBPeriphClockCmd(RCC_APBPeriph_ADC, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC | RCC_AHBPeriph_GPIOD, ENABLE);

  GPIO_Init(GPIOC, GPIO_Pin_6, GPIO_PUPD_NOPULL | GPIO_SPEED_HIGH | GPIO_AF15);

  ADC_InitStruct.ADC_SamplingTime = ADC_SAMPLE_8CYCLE;
  ADC_InitStruct.ADC_SingleChannelSel = ADC_SINGLE_CHANNEL_0;
  ADC_InitStruct.ADC_SingleContinueMode = ADC_MODE_SINGLE;
  ADC_InitStruct.ADC_ClkSel = ADC_CLOCK_PCLK_DIV64;
  ADC_InitStruct.ADC_CircleMode = ADC_MULTICHANNEL_NONCIRCLE;
  ADC_InitStruct.ADC_AutoAccumulation = ADC_AUTOACC_ENABLE;
  ADC_InitStruct.ADC_ExternalTrigConv1 = ADC_SOFTWARE_START;
  ADC_InitStruct.ADC_ExternalTrigConv2 = ADC_SOFTWARE_START;
  ADC_Init(&ADC_InitStruct);

  ADC_Cmd(ENABLE);
  ADC_ClearFlag(ADC_INTFLAG_CHANNEL0);
  ADC_ITConfig(ADC_IT_CHANNEL0, ENABLE);
  NVIC_SetPriority(ADC_IRQn, 1);
  NVIC_EnableIRQ(ADC_IRQn);
  ADC_SoftwareStartConvCmd(ENABLE);
}

/**
  * @brief This function handles ADC Interrupt .
  */
void ADC_IRQHandler(void)
{
  if ((ADC_GetFlagStatus(ADC_IT_CHANNEL0)) != RESET)
  {
    ADC_ClearFlag(ADC_IT_CHANNEL0);
    Channel_0_Value[buffer_index] = ADC_GetConversionValue(ADC_SINGLE_CHANNEL_0);
    buffer_index++;
    if (buffer_index == 10)
    {
      complete_flag = 1;
    }
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
