/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"
//#include "drv_eeprom_24c02.h"
#include "drv_AFE.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t i2c_writeData[10];
uint8_t i2c_readData[10];
uint8_t ADC_Raw[4];
uint8_t i2c_status = 0;
uint8_t AFE_EOC = 0;

/* Private function prototypes -----------------------------------------------*/
void AFE_REG_Ini(void);
/* Private functions ---------------------------------------------------------*/

void delay(volatile uint32_t n)
{
  while (n--)
    ;
}


int main(void)
{
	//uint16_t i ;
	
  SystemCoreClockUpdate();
  
	 RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC, ENABLE);
	
  GPIO_Init(GPIOC, GPIO_Pin_3, GPIO_MODE_IN | GPIO_PUPD_UP); // Set exit IO
  GPIO_EXTIConfig(GPIOC, GPIO_Pin_3, GPIO_EXTI_IT_ENABLE | GPIO_EXTI_TRIGGER_FALLING);
	
  uart1_init(24000000, 115200);
	
	AFE_init();
	
	AFE_REG_Ini();
	
	NVIC_SetPriority(GPIOC_IRQn, 1);
  NVIC_EnableIRQ(GPIOC_IRQn);
	
	AFE_read(0x25,i2c_readData,1);


	/* UART Function */
  printf("AFE Test \r\n");

  
  /* Infinite loop */
  while (1)
  {
			if(AFE_EOC == 1)
			{
				AFE_EOC = 0 ;
				AFE_read(0x00,ADC_Raw,3); // Read ADC( 3-Bytes) , 3bytes in ADC_RAW buffer
				AFE_read(0x25,i2c_readData,0); // Clear flag
			}
			
  }
}

/**
  * @brief This function handles GPIOC Interrupt.
  */
void GPIOC_IRQHandler(void)
{
  if (GPIO_EXTI_GetFlagStatus(GPIOC, GPIO_Pin_3))
  {
    GPIO_EXTI_ClearFlag(GPIOC, GPIO_Pin_3);
		
		//AFE_read(0x25,i2c_readData,1);
		AFE_EOC = 1;
		
		
  }
	
	
	
}

void AFE_REG_Ini()
{
	// OSR
	i2c_writeData[0] = 0x00;
	AFE_write(OSR, i2c_writeData, 1);
	
	// ENCFG0
	i2c_writeData[0] = 0x07;
	AFE_write(ENCFG0, i2c_writeData, 1);
	
	// SIGCFG1
	i2c_writeData[0] = 0x00;
	AFE_write(SIGCFG1, i2c_writeData, 1);
	
	// SIGCFG2 ( Select Ch)
	i2c_writeData[0] = 0x89; // CH0:0x80 , CH1: 0x89 , CH2:0x92
	AFE_write(SIGCFG2, i2c_writeData, 1);	
	
	// VRCFG
	i2c_writeData[0] = 0x8A;
	AFE_write(VRCFG, i2c_writeData, 1);	
	
	// ENCFG1
	i2c_writeData[0] = 0x00;
	AFE_write(ENCFG1, i2c_writeData, 1);	
	
	// PGASET
	i2c_writeData[0] = 0x00;
	AFE_write(PGASET, i2c_writeData, 1);	
	
	// ADCSET
	i2c_writeData[0] = 0x80;
	AFE_write(ADCSET, i2c_writeData, 1);	
	
	// DCSET
	i2c_writeData[0] = 0x00;
	AFE_write(DCSET, i2c_writeData, 1);	
	
	// TSNS
	i2c_writeData[0] = 0x01;
	AFE_write(TSNS, i2c_writeData, 1);	
	
	// IDAC1
	i2c_writeData[0] = 0x00;
	AFE_write(IDAC1CTR, i2c_writeData, 1);	
	
	// IDAC2
	i2c_writeData[0] = 0x00;
	AFE_write(IDAC2CTR, i2c_writeData, 1);	
	
	// SYSCLK
	i2c_writeData[0] = 0x01;
	AFE_write(SYSCLK, i2c_writeData, 1);	
	
	// INSTAT
	i2c_writeData[0] = 0x01;
	AFE_write(INSTA, i2c_writeData, 1);	
	
}



#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
