/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/

BEEP_InitTypeDef BEEP_InitStructure;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void delay(uint32_t ticks)
{
  while (ticks--) ;
}

int main(void)
{
  SystemCoreClockUpdate();

  /*
    PD4  (BEEP)
  */
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);
  GPIO_Init(GPIOD, GPIO_Pin_4, GPIO_SPEED_HIGH | GPIO_PUPD_UP | GPIO_OTYPE_PP | GPIO_AF7);

  /* Enable BEEP Clock */
  RCC_APBPeriphClockCmd(RCC_APBPeriph_BEEP, ENABLE);

  /* Config BEEP Output 120K Singal */
  BEEP_InitStructure.BEEP_ClkSel = BEEP_ClkSel_PCLK;
  BEEP_InitStructure.BEEP_OutDiv = BEEP_OutDiv2;
  BEEP_InitStructure.BEEP_Prescaler = 99;
  BEEP_Init(BEEP, &BEEP_InitStructure);

  BEEP_Cmd(BEEP, ENABLE);

  /* Infinite loop */
  while (1)
  {
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
