/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void delay(uint32_t ticks)
{
  while (ticks--)
    ;
}

void GPIO_KEY_Init(void)
{
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);

  GPIO_Init(GPIOA, GPIO_Pin_3, GPIO_MODE_IN | GPIO_PUPD_DOWN);

  GPIO_DebounceConfig(GPIOA, GPIO_Pin_3, GPIO_DB_ENABLE | GPIO_DB_CLK_DIV_32768);
  GPIO_EXTIConfig(GPIOA, GPIO_Pin_3, GPIO_EXTI_IT_ENABLE | GPIO_EXTI_TRIGGER_EDGE | GPIO_EXTI_TRIGGER_RISSING);
  NVIC_SetPriority(GPIOA_IRQn, 1);
  NVIC_EnableIRQ(GPIOA_IRQn);
}

void GPIO_LED_Init(void)
{
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);

  GPIO_Init(GPIOD, GPIO_Pin_4, GPIO_MODE_OUT | GPIO_OTYPE_PP);

  GPIO_SetBits(GPIOD, GPIO_Pin_4);
}

void GPIOA_IRQHandler(void)
{
  if (GPIO_EXTI_GetFlagStatus(GPIOA, GPIO_Pin_3))
  {
    GPIO_EXTI_ClearFlag(GPIOA, GPIO_Pin_3);
    GPIO_ToggleBits(GPIOD, GPIO_Pin_4);
  }
}

int main(void)
{
  SystemCoreClockUpdate();

  GPIO_LED_Init();
  GPIO_KEY_Init();

  /* Infinite loop */
  while (1)
  {
    ;
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
