/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"
#include "bsp_uart1.h"
#include "drv_eeprom_24c02.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define EEPROM_DEVICE_ADDRESS    0xA0
#define EEPROM_REGISTER_ADDRESS  0x55
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t pWData[2] = {0x12, 0x34};
uint8_t pRData[2] = {0x00, 0x00};
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void delay(volatile uint32_t n)
{
  while (n--)
    ;
}

/* You shoule change the pWData every time to check the I2C */
int main(void)
{
  SystemCoreClockUpdate();

  uart1_init(24000000, 115200);
  eeprom_24c02_init();

  eeprom_24c02_read(EEPROM_DEVICE_ADDRESS, EEPROM_REGISTER_ADDRESS, pRData, 2);
  printf("Read from eeprom data0 =0x%x,data1=0x%x\r\n", pRData[0], pRData[1]);

  eeprom_24c02_write(EEPROM_DEVICE_ADDRESS, EEPROM_REGISTER_ADDRESS, pWData, 2);
  I2C_Stop(ENABLE);
  delay(200000); // Insert a delay time

  eeprom_24c02_read(EEPROM_DEVICE_ADDRESS, EEPROM_REGISTER_ADDRESS, pRData, 2);

  if ((pRData[0] != pWData[0]) || (pRData[1] != pWData[1]))
    printf("Write or read error! data0 =0x%x,data1=0x%x\r\n", pRData[0], pRData[1]);
  else
  {
    printf("Write or read right!\r\n");
    printf("Read from eeprom data0 =0x%x,data1=0x%x\r\n", pRData[0], pRData[1]);
  }

  /* Infinite loop */
  while (1)
  {
    ;
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
