/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
#define LPTIMx_FREQ            1000 /* 1KHz */
#define LPTIMx_RELOADVALUE     (0xFFFF - 24000000 / (LPTIMx_FREQ * 2))
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void LPTIM_Init(void);
/* Private functions ---------------------------------------------------------*/

/* You can see a pwm output in PD2(frequency = 1 KHz)  and a complementary output in PD3*/
int main(void)
{
  SystemCoreClockUpdate();

  LPTIM_Init();

  /* Infinite loop */
  while (1)
  {
    ;
  }
}

void LPTIM_Init(void)
{
  LPTIM_BaseInitTypeDef Base_InitStruct = {0};

  RCC_APBPeriphClockCmd(RCC_APBPeriph_LPTIM, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);

  GPIO_Init(GPIOD, GPIO_Pin_2, GPIO_PUPD_UP | GPIO_SPEED_HIGH | GPIO_OTYPE_PP);
  GPIO_SetAFPin(GPIOD, GPIO_Pin_2, GPIO_AF6);
  GPIO_Init(GPIOD, GPIO_Pin_3, GPIO_PUPD_UP | GPIO_SPEED_HIGH | GPIO_OTYPE_PP);
  GPIO_SetAFPin(GPIOD, GPIO_Pin_3, GPIO_AF6);

  Base_InitStruct.ClkSel = LPTIM_CLOCK_SOURCE_PCLK;
  Base_InitStruct.CntTimSel = LPTIM_TIMER_SELECT;
  Base_InitStruct.AutoReload = LPTIM_AUTORELOAD_ENABLE;
  Base_InitStruct.Period = LPTIMx_RELOADVALUE;
  Base_InitStruct.TogEnable = LPTIM_TOG_ENABLE;
  LPTIM_BaseInit(&Base_InitStruct);

  LPTIM_TCKCmd(ENABLE);
  LPTIM_Cmd(ENABLE);
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
