/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"
#include "bsp_uart1.h"
#include <stdio.h>

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void MY_LVD_Init(void);
/* Private functions ---------------------------------------------------------*/

/* You should pull down vcc lower than 2.9v(for 32 pin the voltage is 3.6v) to use this test program. */
int main(void)
{
  SystemCoreClockUpdate();

  uart1_init(24000000, 115200);

  if (RCC_GetResetFlagStatus(RCC_RSTFLAG_LVDRST) != RESET)
  {
    RCC_ClearResetFlags(RCC_RSTFLAG_LVDRST);
    printf("LVD reset generated\n");
  }

  MY_LVD_Init();

  /* Infinite loop */
  while (1)
  {
    ;
  }
}

void MY_LVD_Init(void)
{
  LVD_InitTypeDef LVD_InitStruct = {0};

  /* Start LSI for LVD filter */
  RCC_LSIConfig(LSI_VALUE_32K, RCC_LSI_STARTUP_4CYCLE, ENABLE);
  RCC_APBPeriphClockCmd(RCC_APBPeriph_LVDVC, ENABLE);

  LVD_InitStruct.FltClkSel = LVD_FLTCLK_LSI;
  LVD_InitStruct.VoltageLevel = LVD_VOLLEVEL_5;
  /* Rising_Trigger means from lower than threshold to higher than threshold */
  LVD_InitStruct.TriggerSel = LVD_TRIGGER_RISING;
  LVD_InitStruct.Action = LVD_ACTION_RESET;
  LVD_InitStruct.FltNum = 0x8000;
  LVD_Init(&LVD_InitStruct);

  LVD_Cmd(ENABLE);
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
