/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint8_t ReceiveArea[3];

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void delay(volatile uint32_t n)
{
  while (n--)
    ;
}

void OneWire_Init(void)
{
  OWIRE_InitTypeDef OWIRE_InitStruct;

  SystemCoreClockUpdate();

  RCC_APBPeriphClockCmd(RCC_APBPeriph_OWIRE, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);
  GPIO_Init(GPIOD, GPIO_Pin_2, GPIO_OTYPE_OD | GPIO_PUPD_UP | GPIO_AF7);

  OWIRE_DeInit();

  OWIRE_InitStruct.ClockDiv = OWIRE_CLOCK_DIVIDER_1;
  OWIRE_InitStruct.FirstBit = OWIRE_FIRSTBIT_LSB;
  OWIRE_InitStruct.DataSize = OWIRE_DATASIZE_8BIT;
  OWIRE_InitStruct.ReadMode = OWIRE_RDMODE_0;
  OWIRE_InitStruct.NoiseFilterEn = OWIRE_NOISE_FILTER_DISABLE;
  OWIRE_InitStruct.NoiseFilterClk = OWIRE_NOISE_FILTER_CLK_DIV_1;
  OWIRE_InitStruct.ResetCounter = 480;
  OWIRE_InitStruct.PresencePulseCounter = 60;
  OWIRE_InitStruct.BitRateCounter = 60;
  OWIRE_InitStruct.DriveCounter = 3;
  OWIRE_InitStruct.ReadSamplingCounter = 10;
  OWIRE_InitStruct.RecoverCounter = 13;
  OWIRE_Init(&OWIRE_InitStruct);

  OWIRE_Cmd(ENABLE);
}

uint8_t OneWire_WaitOnFlagUntilTimeout(uint32_t Flag, FlagStatus Status, uint32_t Timeout)
{
  while (OWIRE_GetFlagStatus(Flag) != Status)
  {
    if (Timeout)
      Timeout--;
    else
      return 0;
  }

  return 1;
}

uint8_t OneWire_Receive(uint8_t *Data, uint32_t Size)
{
  OWIRE_WriteCommand(OWIRE_COMMAND_INIT); // INIT command

  if (OneWire_WaitOnFlagUntilTimeout(OWIRE_FLAG_INITDONE, SET, 0xFFFFFF) != 1)
  {
    return 0;
  }
  OWIRE_ClearFlag(OWIRE_FLAG_INITDONE);

  if (OWIRE_GetFlagStatus(OWIRE_FLAG_ACKERROR))
  {
    OWIRE_ClearFlag(OWIRE_FLAG_ACKERROR);
    return 0;
  }

  // Start
  while (Size)
  {
    Size--;

    OWIRE_WriteCommand(OWIRE_COMMAND_RX);

    if (OneWire_WaitOnFlagUntilTimeout(OWIRE_FLAG_RXDONE, SET, 0xFFFFFF) != 1)
    {
      return 0;
    }
    OWIRE_ClearFlag(OWIRE_FLAG_RXDONE);

    *Data++ = OWIRE_ReadData();
  }

  return 1;
}

int main(void)
{
  SystemCoreClockUpdate();

  // Enable GPIOD clock
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);

  // Config GPIO
  GPIO_Init(GPIOD, GPIO_Pin_4, GPIO_MODE_OUT | GPIO_OTYPE_PP);
  GPIO_SetBits(GPIOD, GPIO_Pin_4);

  OneWire_Init();
  OneWire_Receive(ReceiveArea, 3);

  /* Infinite loop */
  while (1)
  {
    delay(1000000);
    GPIO_ToggleBits(GPIOD, GPIO_Pin_4);
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
