/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"
#include "bsp_uart1.h"
#include <stdio.h>
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
uint32_t CaptureValue, CaptureValueOld, CaptureValueNew, Frequency;
uint32_t OverflowCnt;
uint8_t CaptureCmpFlag;
/* Private function prototypes -----------------------------------------------*/
void PCA_Init(void);
/* Private functions ---------------------------------------------------------*/

/* UART1 will print message about every 1s */
/* PA3(PCA_Channel_2) will output 11.8KHz sqaure wave. */
int main(void)
{
  SystemCoreClockUpdate();

  uart1_init(24000000, 115200);
  PCA_Init();

  /* Infinite loop */
  while (1)
  {
    if (CaptureCmpFlag == 1)
    {
      CaptureCmpFlag = 0;
      CaptureValueNew = CaptureValue;
      if (CaptureValueNew != CaptureValueOld)
      {
        if (CaptureValueNew > CaptureValueOld)
        {
          /* PCA clock source is PCLK/8 = 24M/8 = 3MHz */
          Frequency = 3000000 / (CaptureValueNew - CaptureValueOld);
        }
      }
      CaptureValueOld = CaptureValueNew;
    }
    /* print frequency every second */
    if (OverflowCnt == 46)
    {
      OverflowCnt = 0;
      printf("Frequecy is %.2f KHz. \n", (Frequency * 1.0 / 1000));
    }
  }
}

void PCA_Init(void)
{
  RCC_APBPeriphClockCmd(RCC_APBPeriph_PCA, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC, ENABLE);

  PCA_BaseInitTypeDef PCA_InitStruct;
  PCA_IC_InitTypeDef PCA_IC_InitStruct;

  /* Initialize the input capture pin */
  GPIO_Init(GPIOC, GPIO_Pin_6, GPIO_SPEED_HIGH | GPIO_PUPD_UP | GPIO_OTYPE_PP);
  GPIO_SetAFPin(GPIOC, GPIO_Pin_6, GPIO_AF2);

  /* PCA base initialization */
  PCA_InitStruct.ClkSrcSel = PCA_CLOCK_SOURCE_PCLKDIV8;
  PCA_InitStruct.RunInIdleMode = PCA_IDLEMODE_DISABLE;
  PCA_BaseInit(&PCA_InitStruct);

  /* PCA input capture configuration */
  PCA_IC_InitStruct.ICPolarity = PCA_INPUT_POLARITY_FALLING;
  PCA_IC_InitStruct.Channel = PCA_CHANNEL_3;
  PCA_IC_Config(&PCA_IC_InitStruct);

  /* PCA interrupt configuartion */
  PCA_ITConfig(PCA_IT_OVERFLOW | PCA_IT_CC3, ENABLE);
  NVIC_SetPriority(PCA_IRQn, 1);
  NVIC_EnableIRQ(PCA_IRQn);

  /* PCA enable */
  PCA_Cmd(ENABLE);
}

void PCA_IRQHandler(void)
{
  if (PCA_GetFlagStatus(PCA_FLAG_OVERFLOW) != RESET)
  {
    PCA_ClearITPendingBit(PCA_FLAG_OVERFLOW);
    OverflowCnt++;
  }
  if (PCA_GetFlagStatus(PCA_FLAG_CC3) != RESET)
  {
    PCA_ClearITPendingBit(PCA_FLAG_CC3);
    CaptureCmpFlag = 1;
    CaptureValue = PCA_GetCompareValue(PCA_CHANNEL_3);
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
