/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void PCA_Init(void);
/* Private functions ---------------------------------------------------------*/

/* UART1 will print message about every 1s */
/* PA3(PCA_Channel_2) will output 11.8KHz sqaure wave. */
int main(void)
{
  SystemCoreClockUpdate();

  PCA_Init();

  /* Infinite loop */
  while (1)
  {
    ;
  }
}

/* PA3(PCA_Channel_2) will output 11.8KHz sqaure wave. */
void PCA_Init(void)
{
  RCC_APBPeriphClockCmd(RCC_APBPeriph_PCA, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);

  PCA_BaseInitTypeDef PCA_InitStruct;
  PCA_OC_InitTypeDef PCA_OC_InitStruct;

  /* Initialize the output pwm pin */
  GPIO_Init(GPIOA, GPIO_Pin_3, GPIO_SPEED_HIGH | GPIO_PUPD_UP | GPIO_OTYPE_PP);
  GPIO_SetAFPin(GPIOA, GPIO_Pin_3, GPIO_AF2);

  /* PCA base initialization */
  PCA_InitStruct.ClkSrcSel = PCA_CLOCK_SOURCE_PCLKDIV8;
  PCA_InitStruct.RunInIdleMode = PCA_IDLEMODE_DISABLE;
  PCA_BaseInit(&PCA_InitStruct);

  /* PCA output pwm configuration */
  PCA_OC_InitStruct.CompareEnable = PCA_OC_ENABLE;
  PCA_OC_InitStruct.PwmEnable = PCA_PWM_ENABLE;
  PCA_OC_InitStruct.TogEnable = PCA_TOG_DISABLE;
  /* 50% duty cycle, period = (0x80*2)*(1/3M) = 84us */
  PCA_OC_InitStruct.Period = 0x80;
  PCA_OC_InitStruct.Channel = PCA_CHANNEL_2;
  PCA_OC_Config(&PCA_OC_InitStruct);
  PCA_OC_Cmd(PCA_OC_InitStruct.Channel, ENABLE);

  /* PCA enable */
  PCA_Cmd(ENABLE);
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
