/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/

void SystemClock_Config(void);

/* Private functions ---------------------------------------------------------*/

void delay(uint32_t ticks)
{
  while (ticks--)
    ;
}

int main(void)
{
  SystemClock_Config();

  SystemCoreClockUpdate();

  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);

  GPIO_Init(GPIOD, GPIO_Pin_4, GPIO_MODE_OUT | GPIO_OTYPE_PP);

  /* Infinite loop */
  while (1)
  {
    delay(1000000);
    GPIO_ToggleBits(GPIOD, GPIO_Pin_4);
  }
}

/**
  * @brief  Configures the SYS clock frequency, AHB and APB prescalers.
  * @return None
  */
void SystemClock_Config(void)
{
  /* Enable HSE and LSE */
  RCC_HSEConfig(RCC_HSE_ON);
  RCC_LSEConfig(RCC_LSE_ON);

  /* wait HSE clock ready */
  while ((RCC->HSECR & RCC_HSECR_HSERDY) == RESET)
    ;

  /* wait LSE clock ready */
  while ((RCC->LSECR & RCC_LSECR_LSERDY) == RESET)
    ;

  /* Select HSE as system clock source */
  RCC_SYSCLKConfig(RCC_SYSCLKSource_HSE);

  /* Wait till clock switch is ready */
  while ((RCC->SYSCLKSEL & RCC_SYSCLKSEL_CLKSW) != RCC_SYSCLKSource_HSE)
    ;

  RCC_AHBCLKConfig(RCC_AHBCLKDiv1);
  RCC_APBCLKConfig(RCC_APBCLKDiv1);
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
