/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
const uint8_t WriteData[] = {0x52, 0x79, 0x0C, 0xAF, 0xC0, 0x99, 0x44, 0x71, 0x9D, 0x30, 0xAD, 0x68};
uint8_t ReadBuffer[sizeof(WriteData)];

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void delay(uint32_t ticks)
{
  while (ticks--)
    ;
}

void GPIO_LED_Init(void)
{
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);

  GPIO_Init(GPIOD, GPIO_Pin_4, GPIO_MODE_OUT | GPIO_OTYPE_PP);

  GPIO_SetBits(GPIOD, GPIO_Pin_4);
}

void SPI_MasterInit(void)
{
  SPI_InitTypeDef SPI_InitStructure;

  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);
  RCC_APBPeriphClockCmd(RCC_APBPeriph_SPI, ENABLE);

  /*
    PA3 (SPI_NSS)
    PC5 (SPI_SCK)
    PD3 (SPI_MOSI)
    PD2 (SPI_MISO)
  */
  GPIO_Init(GPIOA, GPIO_Pin_3, GPIO_MODE_OUT | GPIO_PUPD_UP | GPIO_AF3);
  GPIO_Init(GPIOC, GPIO_Pin_5, GPIO_MODE_OUT | GPIO_PUPD_UP | GPIO_AF3);
  GPIO_Init(GPIOD, GPIO_Pin_3, GPIO_MODE_OUT | GPIO_PUPD_UP | GPIO_AF3);
  GPIO_Init(GPIOD, GPIO_Pin_2, GPIO_MODE_IN | GPIO_AF3);

  SPI_DeInit(SPI);
  SPI_InitStructure.SPI_TransferMode = SPI_MODE_MASTER;
  SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
  SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;
  SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BAUD_RATE_PRESCALER_8;
  SPI_Init(SPI, &SPI_InitStructure);

  SPI_NSSConfig(SPI, DISABLE);

  SPI_Cmd(SPI, ENABLE);
}

void SPI_MasterExchangeData(const uint8_t *TxData, uint32_t TxSize, uint8_t *RxData, uint32_t RxSize)
{
  uint8_t data;

  while (TxSize)
  {
    SPI_NSSConfig(SPI, ENABLE);
    delay(10000);

    while (SPI_GetFlagStatus(SPI, SPI_FLAG_SPIF) != RESET)
      ;

    SPI_WriteData(SPI, *TxData);

    while (SPI_GetFlagStatus(SPI, SPI_FLAG_SPIF) != SET)
      ;

    data = SPI_ReadData(SPI);

    if (RxSize)
    {
      *RxData = data;
      RxSize--;
    }

    SPI_NSSConfig(SPI, DISABLE);
    delay(10000);

    TxData++;
    RxData++;
    TxSize--;
  }
}

int main(void)
{
  SystemCoreClockUpdate();

  GPIO_LED_Init();
  SPI_MasterInit();

  SPI_MasterExchangeData(WriteData, sizeof(WriteData), ReadBuffer, sizeof(ReadBuffer));

  /* Infinite loop */
  while (1)
  {
    delay(1000000);
    GPIO_ToggleBits(GPIOD, GPIO_Pin_4);
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
