/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"

/* Private typedef -----------------------------------------------------------*/
typedef enum
{
  SPI_ERROR = 1,
  SPI_SUCCESS,
  SPI_START,
  SPI_OVERFLOW
} SPI_Status;

typedef struct
{
  const uint8_t *TxBuffer;
  uint32_t TxSize;
  uint32_t TxCount;
  uint8_t *RxBuffer;
  uint32_t RxSize;
  uint32_t RxCount;
  SPI_Status Status;
} SPI_IT_HandleTypeDef;

/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
const uint8_t WriteData[] = {0x52, 0x79, 0x0C, 0xAF, 0xC0, 0x99, 0x44, 0x71, 0x9D, 0x30, 0xAD, 0x68};
uint8_t ReadBuffer[sizeof(WriteData)];
SPI_IT_HandleTypeDef SPI_Handler = {0};

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void delay(uint32_t ticks)
{
  while (ticks--)
    ;
}

void GPIO_LED_Init(void)
{
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);

  GPIO_Init(GPIOD, GPIO_Pin_4, GPIO_MODE_OUT | GPIO_OTYPE_PP);

  GPIO_SetBits(GPIOD, GPIO_Pin_4);
}

void SPI_SlaveInit(void)
{
  SPI_InitTypeDef SPI_InitStructure;

  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOA, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOC, ENABLE);
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);
  RCC_APBPeriphClockCmd(RCC_APBPeriph_SPI, ENABLE);
  RCC_APBPeriphClockCmd(RCC_APBPeriph_SYSCON, ENABLE);

  /*
    PA3 (SPI_NSS)
    PC5 (SPI_SCK)
    PD3 (SPI_SIMO)
    PD2 (SPI_SOMI)
  */
  GPIO_Init(GPIOA, GPIO_Pin_3, GPIO_MODE_IN | GPIO_AF3);
  GPIO_Init(GPIOC, GPIO_Pin_5, GPIO_MODE_IN | GPIO_AF3);
  GPIO_Init(GPIOD, GPIO_Pin_3, GPIO_MODE_IN | GPIO_AF3);
  GPIO_Init(GPIOD, GPIO_Pin_2, GPIO_MODE_OUT | GPIO_PUPD_UP | GPIO_AF3);

  SPI_DeInit(SPI);
  SPI_InitStructure.SPI_TransferMode = SPI_MODE_SLAVE;
  SPI_InitStructure.SPI_CPOL = SPI_CPOL_Low;
  SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;
  SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BAUD_RATE_PRESCALER_8;
  SPI_Init(SPI, &SPI_InitStructure);
  NVIC_SetPriority(SPI_IRQn, 1);
  NVIC_DisableIRQ(SPI_IRQn);

  SYSCON_SPINCS(SYSCON_SPI_NCS_PA3);

  SPI_Cmd(SPI, ENABLE);
}

void SPI_IT_SlaveExchangeData(uint8_t *RxData, uint32_t RxSize, const uint8_t *TxData, uint32_t TxSize)
{
  SPI_Handler.TxBuffer = TxData;
  SPI_Handler.TxSize = TxSize;
  SPI_Handler.TxCount = 0;
  SPI_Handler.RxBuffer = RxData;
  SPI_Handler.RxSize = RxSize;
  SPI_Handler.RxCount = 0;
  SPI_Handler.Status = SPI_START;

  if (SPI_Handler.TxCount < SPI_Handler.TxSize)
  {
    SPI_WriteData(SPI, SPI_Handler.TxBuffer[SPI_Handler.TxCount++]);
  }

  NVIC_EnableIRQ(SPI_IRQn);
  while (SPI_Handler.Status == SPI_START)
    ;
}

/**
  * @brief This function handles SPI Interrupt.
  */
void SPI_IRQHandler(void)
{
  uint8_t data;

  data = SPI_ReadData(SPI);
  if (SPI_GetFlagStatus(SPI, SPI_FLAG_SPIF))
  {
    if (SPI_Handler.RxCount < SPI_Handler.RxSize)
    {
      SPI_Handler.RxBuffer[SPI_Handler.RxCount++] = data;
      if (SPI_Handler.RxCount == SPI_Handler.RxSize)
      {
        SPI_Handler.Status = SPI_SUCCESS;
        NVIC_DisableIRQ(SPI_IRQn);
      }
    }
    else
    {
      SPI_Handler.Status = SPI_OVERFLOW;
      NVIC_DisableIRQ(SPI_IRQn);
    }

    if (SPI_Handler.TxCount < SPI_Handler.TxSize)
    {
      SPI_WriteData(SPI, SPI_Handler.TxBuffer[SPI_Handler.TxCount++]);
    }
    else
    {
      SPI_WriteData(SPI, 0xFF);
    }
  }
  else if (SPI_GetFlagStatus(SPI, SPI_FLAG_WCOL | SPI_FLAG_SSERR | SPI_FLAG_MDF))
  {
    SPI_Handler.Status = SPI_ERROR;
  }
}

int main(void)
{
  SystemCoreClockUpdate();

  GPIO_LED_Init();
  SPI_SlaveInit();

  SPI_IT_SlaveExchangeData(ReadBuffer, sizeof(ReadBuffer), WriteData, sizeof(WriteData));

  /* Infinite loop */
  while (1)
  {
    delay(1000000);
    GPIO_ToggleBits(GPIOD, GPIO_Pin_4);
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
