/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
TIM_TimeBaseInitTypeDef TIM_TimeBaseInitStructure;
TIM_ICInitTypeDef  TIM_ICInitStructure;

uint32_t capture_flag  = 0;
uint32_t capture_count = 0;
uint32_t capture_time  = 0;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void delay(uint32_t ticks)
{
  while (ticks--)
    ;
}

int main(void)
{
  SystemCoreClockUpdate();

  /*
    TIM1_CH1 PD4
  */
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);
  GPIO_Init(GPIOD, GPIO_Pin_4, GPIO_OTYPE_OD | GPIO_PUPD_DOWN | GPIO_SPEED_HIGH | GPIO_AF1);

  /* Enable TIM1 Clock */
  RCC_APBPeriphClockCmd(RCC_APBPeriph_TIM1, ENABLE);
  TIM_DeInit(TIM1);

  NVIC_SetPriority(TIM1_IRQn, 1);
  NVIC_EnableIRQ(TIM1_IRQn);

  TIM_ARRPreloadConfig(TIM1, DISABLE);
  /* Time base configuration */
  TIM_TimeBaseInitStructure.TIM_Period = (10000 - 1);
  TIM_TimeBaseInitStructure.TIM_Prescaler = (24 - 1);
  TIM_TimeBaseInitStructure.TIM_ClockDivision = TIM_CKD_DIV1;
  TIM_TimeBaseInitStructure.TIM_CounterMode = TIM_CounterMode_Up;
  TIM_TimeBaseInitStructure.TIM_RepetitionCounter = 0;
  TIM_TimeBaseInit(TIM1, &TIM_TimeBaseInitStructure);
  TIM_ARRPreloadConfig(TIM1, ENABLE);

  /* TIM input channel config */
  TIM_ICInitStructure.TIM_Channel = TIM_Channel_1;
  TIM_ICInitStructure.TIM_ICPolarity = TIM_ICPolarity_Rising;
  TIM_ICInitStructure.TIM_ICSelection = TIM_ICSelection_DirectTI;
  TIM_ICInitStructure.TIM_ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStructure.TIM_ICFilter = 0x0;
  TIM_ICInit(TIM1, &TIM_ICInitStructure);

  TIM_ClearFlag(TIM1, TIM_IT_CC1 | TIM_IT_Update);
  TIM_ITConfig(TIM1, TIM_IT_Update | TIM_IT_CC1, ENABLE);
  TIM_Cmd(TIM1, ENABLE);

  /* Infinite loop */
  while (1)
  {
  }
}

/**
  * @brief This function handles TIM1 Interrupt .
  */
void TIM1_IRQHandler(void)
{
  if (TIM_GetFlagStatus(TIM1, TIM_IT_CC1) != RESET)
  {
    if (capture_flag == 0)
    {
      TIM_SetCounter(TIM1, 0);
      capture_time = 0;
      capture_flag ++;
      TIM_OC1PolarityConfig(TIM1, TIM_ICPolarity_Falling);
    }
    else
    {
      capture_time = (TIM_GetCapture1(TIM1) + capture_count * 10000) / 1000;
      capture_count = 0;
      capture_flag = 0;
      TIM_OC1PolarityConfig(TIM1, TIM_ICPolarity_Rising);
    }
    TIM_ClearFlag(TIM1, TIM_IT_CC1);
  }
  if (TIM_GetITStatus(TIM1, TIM_IT_Update) != RESET)
  {
    if(capture_flag == 1)
    {
      capture_count ++;
    }
    TIM_ClearFlag(TIM1, TIM_FLAG_Update);
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
