/* Includes ------------------------------------------------------------------*/
#include "FE82160.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
UART_InitTypeDef UART_InitStructure;
uint8_t send_buf[] = {0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F};

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
void delay(uint32_t ticks)
{
  while (ticks--)
    ;
}

int main(void)
{
  uint8_t *p;

  SystemCoreClockUpdate();

  /*
    PD5 UART1_TX
    PD6 UART1_RX
   */
  RCC_AHBPeriphClockCmd(RCC_AHBPeriph_GPIOD, ENABLE);
  GPIO_Init(GPIOD, GPIO_Pin_5 | GPIO_Pin_6, GPIO_PUPD_NOPULL | GPIO_OTYPE_PP | GPIO_SPEED_HIGH | GPIO_AF7);

  /* Enable UART1 */
  RCC_APBPeriphClockCmd(RCC_APBPeriph_UART1, ENABLE);
  UART_DeInit(UART1);

  /* UART1 Config Init Param */
  UART_InitStructure.UART_BandDouble = UART_BandDouble_Enable;
  UART_InitStructure.UART_BaudRate = 115200;
  UART_InitStructure.UART_BaudRateMode = UART_BaudRateMode_Self;
  UART_InitStructure.UART_WordLength = UART_WordLength_8b;
  UART_Init(UART1, &UART_InitStructure);

  UART_Cmd(UART1, ENABLE);

  UART_IrDACmd(UART1, ENABLE);

  UART_ITConfig(UART1, UART_IT_TI | UART_IT_RI, ENABLE);

  p = send_buf;
  /* Infinite loop */
  while (*p)
  {
    UART_WriteData(UART1, *p++);
    while (UART_GetFlagStatus(UART1, UART_FLAG_TI) == RESET)
      ;
    UART_ClearFlag(UART1, UART_FLAG_TI);
  }

  while (1)
  {
    /* code */
  }
}

#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif
