/**
  * @file    Project/FE82160_StdPeriph_Template/FE82160_conf.h
  * @author  Westberry Application Team
  * @version V0.0.4
  * @date    05-January-2023
  * @brief   Library configuration file.
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __FE82160_CONF_H
#define __FE82160_CONF_H

/* Includes ------------------------------------------------------------------*/
/* Uncomment/Comment the line below to enable/disable peripheral header file inclusion */
#include "FE82160_gpio.h"
#include "FE82160_rcc.h"
#include "FE82160_tim.h"
#include "FE82160_flash.h"
#include "FE82160_uart.h"
#include "FE82160_basetim.h"
#include "FE82160_lpuart.h"
#include "FE82160_pca.h"
#include "FE82160_beep.h"
#include "FE82160_adc.h"
#include "FE82160_lptim.h"
#include "FE82160_vcmp.h"
#include "FE82160_lvd.h"
#include "FE82160_i2c.h"
#include "FE82160_iwdg.h"
#include "FE82160_wwdg.h"
#include "FE82160_spi.h"
#include "FE82160_syscon.h"
#include "FE82160_rtc.h"
#include "FE82160_crc.h"
#include "FE82160_awk.h"
#include "FE82160_owire.h"
#include "FE82160_pwr.h"
#include "misc.h" /* High level functions for NVIC and SysTick (add-on to CMSIS functions) */

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Uncomment the line below to expanse the "assert_param" macro in the 
   Standard Peripheral Library drivers code */
/* #define USE_FULL_ASSERT    1 */

/* Exported macro ------------------------------------------------------------*/
#ifdef  USE_FULL_ASSERT
/**
  * @brief  The assert_param macro is used for function's parameters check.
  * @param  expr: If expr is false, it calls assert_failed function which reports 
  *         the name of the source file and the source line number of the call 
  *         that failed. If expr is true, it returns no value.
  * @retval None
  */
  #define assert_param(expr) ((expr) ? (void)0 : assert_failed((uint8_t *)__FILE__, __LINE__))
/* Exported functions ------------------------------------------------------- */
  void assert_failed(uint8_t* file, uint32_t line);
#else
  #define assert_param(expr) ((void)0)
#endif /* USE_FULL_ASSERT */

#endif /* __FE82160_CONF_H */
